IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Localidades_Cliente') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Localidades_Cliente
END
GO


CREATE PROCEDURE dbo.CPJ_Localidades_Cliente		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por paremetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Cliente			INT
DECLARE @pId_Lista_Precio		INT
DECLARE @pId_Sector				INT


SET @pFlagUsarTrans		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Cliente		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Lista_Precio	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Lista_Precio')), 0)
SET @pId_Sector			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Sector')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @Loca_Fecha_Lim			DATE
DECLARE @Loca_Fecha_Lim_Dias	INT
DECLARE @SqlStr					NVARCHAR(MAX)
DECLARE @SqlStrs				NVARCHAR(MAX)
/*FIN Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Localidades_Cliente'
		PRINT 'Parametros: '+ @pJson  
	END

	/*===================================================================*/


	/*===================================================================*/
	SET @Loca_Fecha_Lim				= ISNULL((SELECT dbo.CF_xParam('Loca_Fecha_Lim')),'19900101')
	SET @Loca_Fecha_Lim_Dias		= ISNULL((SELECT dbo.CF_xParam('Loca_Fecha_Lim_Dias')),0)
	
	/* CREO LA TABLA */
	CREATE TABLE #Table_Localidades (Id_Trans				INT
									, Id_Cliente			INT
									, Id_Lista				INT
									, Razon_Social			VARCHAR(100)
									, Fecha_QA				DATETIME
									, Fecha_Venc			DATETIME
									, Fecha_Desde			DATETIME
									, Fecha_Hasta			DATETIME
									, Descripcion			VARCHAR(100)
									, Id_Producto			VARCHAR(14)
									, Descripcion_Resumida	VARCHAR(100)
									, Estado				VARCHAR(10))

	/* INSERTO EN LA TABLA */
	/*LOCALIDADES COMPRADAS*/
	SET @SqlStr =	'INSERT INTO #Table_Localidades
	SELECT C.Id_Trans, I.Id_Cliente,C.Id_Lista,  CL.Razon_Social, I.Fecha_QA, I.Fecha_Venc ,pp.Fecha_Desde, pp.Fecha_Hasta,pp.Descripcion , I.Id_Producto , RTRIM(LTRIM(p.Descripcion_Resumida)),
	''C''
	FROM Cbtes_Items I , Clientes CL, Cbtes C, Cbtes_Tipos  T,Productos P, Prod_Listas_Precios pp
	WHERE C.Id_Trans = I.Id_Trans
			AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
			AND c.Id_Lista=pp.Id_Lista_Precio
			AND CL.Id_Cliente=I.Id_Cliente
			AND (Compromete_Factura = 1 OR Compromete_Remitos = 1 )
			AND PP.Flag_Localidades=1
			AND I.Id_Producto = P.Id_Producto
			AND P.Tipo = ''L''
			AND I.Flag_QA  =  ''A''
			AND GETDATE()>=DATEADD(DAY,Evento_Cant_Dias_Limite,pp.Fecha_Desde)
			AND C.Id_Estado_Cbte NOT IN(0,3)
			AND (
				(ISNULL(PP.Evento_Cant_Dias_Renov_Prev, 0) > 0 AND I.Fecha_Venc>DATEADD(DAY, ISNULL(PP.Evento_Cant_Dias_Renov_Prev, 0), GETDATE()))
				OR 
				(ISNULL(PP.Evento_Cant_Dias_Renov_Prev, 0) = 0 AND I.Fecha_Venc>GETDATE())
				)'
	--09/11/2021 Ultima linea @SqlStr I.Fecha_Venc>GETDATE() se cambia para agregar "Evento_Cant_Dias_Renov_Prev"

	IF(@pId_Cliente!=0)
	BEGIN
		SET @SqlStr =RTRIM(LTRIM(@SqlStr)) + CHAR(13) +'AND	( c.Id_Cliente =' + CONVERT(VARCHAR(20),@pId_Cliente) +  '
						or c.Id_Cliente_Ref = dbo.CF_Cli_Id_Cliente_Ref(' + CONVERT(VARCHAR(20),@pId_Cliente) + '))'
	END

	IF(@pId_Lista_Precio!=0)
	BEGIN
		SET @SqlStr =RTRIM(LTRIM(@SqlStr)) + CHAR(13) +'AND PP.Id_Lista_Precio= ' + CONVERT(VARCHAR(20),@pId_Lista_Precio) 
	END
			
	IF(@pId_Sector!=0)
	BEGIN
		SET @SqlStr =RTRIM(LTRIM(@SqlStr)) + CHAR(13) +'AND P.Id_Sector= ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pModoDebug = 1)
		BEGIN
			PRINT '@SqlStr: ' + @SqlStr
		END		
	EXECUTE sp_executesql @SqlStr

	/*LOCALIDADES RESERVADAS*/
	IF (CONVERT(DATE,GETDATE())<=@Loca_Fecha_Lim)
	BEGIN

	SET @SqlStr =	'INSERT INTO #Table_Localidades
		SELECT C.Id_Trans, I.Id_Cliente, C.Id_Lista, CL.Razon_Social, I.Fecha_QA, I.Fecha_Venc ,pp.Fecha_Desde, pp.Fecha_Hasta,pp.Descripcion , I.Id_Producto, p.Descripcion_Resumida,
		''R''
		FROM Cbtes_Items I , Clientes CL, Cbtes C, Cbtes_Tipos  T,Productos P, Prod_Listas_Precios pp
		WHERE C.Id_Trans = I.Id_Trans
				AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
				AND c.Id_Lista=pp.Id_Lista_Precio
				AND CL.Id_Cliente=I.Id_Cliente
				AND (Compromete_Factura = 1 OR Compromete_Remitos = 1 )
				AND I.Id_Producto = P.Id_Producto
				AND P.Tipo = ''L''
				AND I.Flag_QA  =  ''A''
				AND C.Id_Estado_Cbte NOT IN(0,3)
				AND pp.Evento_Flag_Renueva in (0,2)
				AND (
				(ISNULL(PP.Evento_Cant_Dias_Renov_Prev, 0) > 0 AND I.Fecha_Venc<=DATEADD(DAY, ISNULL(PP.Evento_Cant_Dias_Renov_Prev, 0), GETDATE()))
				OR 
				(ISNULL(PP.Evento_Cant_Dias_Renov_Prev, 0) = 0 AND I.Fecha_Venc<=GETDATE())
				)
				AND GETDATE()>=DATEADD(DAY,Evento_Cant_Dias_Limite,pp.Fecha_Desde)
				AND PP.Flag_Localidades=1
				AND DATEADD(DAY,' +CONVERT(VARCHAR(5),@Loca_Fecha_Lim_Dias)+',I.Fecha_Venc) >GETDATE()
				AND I.Id_Producto COLLATE Modern_Spanish_CI_AS NOT in (SELECT Id_Producto COLLATE Modern_Spanish_CI_AS FROM #Table_Localidades)'

	--09/11/2021 linea siguiente pp.Evento_Flag_Renueva in (0,2) del @SqlStr "I.Fecha_Venc<=GETDATE()" se cambia para agregar "Evento_Cant_Dias_Renov_Prev"

	IF(@pId_Cliente!=0)
	BEGIN
		SET @SqlStr =RTRIM(LTRIM(@SqlStr)) + CHAR(13) +'AND	( c.Id_Cliente =' + CONVERT(VARCHAR(20),@pId_Cliente) +  '
						or c.Id_Cliente_Ref = dbo.CF_Cli_Id_Cliente_Ref(' + CONVERT(VARCHAR(20),@pId_Cliente) + '))'
	END

	IF(@pId_Lista_Precio!=0)
	BEGIN
		SET @SqlStr =RTRIM(LTRIM(@SqlStr)) + CHAR(13) +'AND PP.Id_Lista_Precio= ' + CONVERT(VARCHAR(20),@pId_Lista_Precio) 
	END

	IF(@pId_Sector!=0)
	BEGIN
		SET @SqlStr =RTRIM(LTRIM(@SqlStr)) + CHAR(13) +'AND P.Id_Sector= ' + CONVERT(VARCHAR(20),@pId_Sector) 
	END

	IF(@pModoDebug = 1)
		BEGIN
			PRINT '@@SqlStrs: ' + @SqlStr
		END		
	EXECUTE sp_executesql @SqlStr
	END


	IF @pFlagUsarTrans <> 0 COMMIT

	SELECT * FROM	#Table_Localidades ORDER BY Id_Cliente 
	
	DROP TABLE #Table_Localidades
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Localidades_Cliente'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 


-- EXEC CPJ_Localidades_Cliente '{"ModoDebug":"1","Id_Cliente":0}'